param (
    [Parameter(Mandatory=$true)][string]$name,
    [Parameter(Mandatory=$true)][string]$givenname,
    [Parameter(Mandatory=$true)][string]$surname,
    [Parameter(Mandatory=$true)][string]$samaccountname,
    [Parameter(Mandatory=$true)][string]$userprincipalname,
    [Parameter(Mandatory=$true)][string]$path,
    [Parameter(Mandatory=$true)][string]$accountpassword,
    [Parameter(Mandatory=$true)][string]$passwordneverexpires,
	[Parameter(Mandatory=$true)][string]$changepasswordatlogin,
	[Parameter(Mandatory=$true)][string]$cannotchangepassword,
	[Parameter(Mandatory=$true)][string]$description,
	[Parameter(Mandatory=$true)][string]$scriptpath,
	[Parameter(Mandatory=$true)][string]$homedrive,
	[Parameter(Mandatory=$true)][string]$homedirectory,
    [Parameter(Mandatory=$true)][string]$email,
    [Parameter(Mandatory=$true)][string]$groepen
)

$accountpasswordss = $accountpassword | ConvertTo-SecureString -AsPlainText -Force
$blnpasswordneverexpires  = [boolean]::Parse($passwordneverexpires)
$blnchangepasswordatlogin = [boolean]::Parse($changepasswordatlogin)
$blncannotchangepassword  = [boolean]::Parse($cannotchangepassword)

# Omschrijving
    if($description -eq "empty"){
        $strdescription = ""
    }
    else{
        $strdescription = $description
    }

# Script path
    if($scriptpath -eq "empty"){
        $strscriptpath = ""
    }
    else{
        $strscriptpath = $scriptpath
    }

# Homedrive
    if($homedrive -eq "empty"){
        $strhomedrive = ""
    }
    else{
        $strhomedrive = $homedrive
    }

# Home Directory
    if($homedirectory -eq "empty"){
        $strhomedirectory = ""
    }
    else{
        $strhomedirectory = $homedirectory
    }

# E-mail
    if($email -eq "empty"){
        $stremail = ""
    }
    else{
        $stremail = $email
    }

try{
    New-ADUser  -Name $name `
                -GivenName $givenname `
                -Surname $surname `
                -DisplayName $name `
                -SamAccountName $samaccountname `
                -UserPrincipalName $userprincipalname `
                -Path $path `
                -AccountPassword $accountpasswordss `
                -PasswordNeverExpires $blnpasswordneverexpires `
                -ChangePasswordAtLogon $blnchangepasswordatlogin `
                -CannotChangePassword $blncannotchangepassword `
                -Description $strdescription `
			    -scriptPath $strscriptpath `
                -HomeDrive $strhomedrive `
                -HomeDirectory $strhomedirectory `
                -EmailAddress $stremail `
			    -Enabled $True
    try{
        if($groepen -ne "empty"){
            $arrgroepen = $groepen -split ","

            foreach($groep in $arrgroepen)
            {
                Add-ADGroupMember -Identity $groep -Members $samaccountname
            }
        }
    }
    catch{
        Write-Host "Fout bij het toevoegen van gebruiker $userprincipalname aan groep $groepen"
    }
}
catch{
    Write-Host "Fout bij het aanmaken van $userprincipalname"
}